package com.kyfexuwu.server_guis;

import com.kyfexuwu.server_guis.consumers.ClickConsumer;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.minecraft.class_1291;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Optional;

public class ServerGUIs implements DedicatedServerModInitializer {
	public static final Logger LOGGER = LoggerFactory.getLogger("Server GUIs");
	public enum ScreenType{
		GENERIC_9X1(class_3917.field_18664,9),
		GENERIC_9X2(class_3917.field_18665,18),
		GENERIC_9X3(class_3917.field_17326,27),
		GENERIC_9X4(class_3917.field_18666,36),
		GENERIC_9X5(class_3917.field_18667,45),
		GENERIC_9X6(class_3917.field_17327,54),
		GENERIC_3X3(class_3917.field_17328,9),
		ANVIL(class_3917.field_17329,3),
		BEACON(class_3917.field_17330,1, 3),
		BLAST_FURNACE(class_3917.field_17331,3, 4),
		BREWING_STAND(class_3917.field_17332,5, 2),
		FURNACE(class_3917.field_17335,3, 4),
		GRINDSTONE(class_3917.field_17336,3),
		HOPPER(class_3917.field_17337,5),
		//LEGACY_SMITHING(ScreenHandlerType.LEGACY_SMITHING),
		SMITHING(class_3917.field_22484,4),
		SMOKER(class_3917.field_17342,3, 4);
		//try to add crafting (1)
		//try to add enchanting (2)
		//try to add loom and stonecutter (3)
		//cartography table look into (4)

		public final class_3917<?> type;
		public final int slotCount;
		public final int propCount;
		ScreenType(class_3917<?> type, int slotCount){
			this(type, slotCount, 0);
		}
		ScreenType(class_3917<?> type, int slotCount, int propCount){
			this.type=type;
			this.slotCount=slotCount;
			this.propCount=propCount;
		}
	}

	private static void checkGUIType(InvGUI<?> gui, String errorMessage, ScreenType... types){
		for(var type : types){
			if(gui.type==type) return;
		}
		throw new IllegalArgumentException(errorMessage);
	}

	public static void setBeaconLevel(InvGUI<?> gui, int level){
		checkGUIType(gui, "Tried to set beacon level of gui "+gui+", but the gui is not a beacon gui!",
				ScreenType.BEACON);

		gui.propertyDelegate.method_17391(0,level);
	}
	public static void setBeaconEffects(InvGUI<?> gui, Optional<class_1291> effect1, Optional<class_1291> effect2){
		checkGUIType(gui, "Tried to set status effects of gui "+gui+", but the gui is not a beacon gui!",
				ScreenType.BEACON);

		effect1.ifPresent(statusEffect ->
				gui.propertyDelegate.method_17391(1, class_1291.method_5554(statusEffect)));
		effect2.ifPresent(statusEffect ->
				gui.propertyDelegate.method_17391(2, class_1291.method_5554(statusEffect)));
	}
	public static void setFurnaceCookProgress(InvGUI<?> gui, double cookProgress){
		checkGUIType(gui, "Tried to set cook data of gui "+gui+", but the gui is not a furnace type gui!",
				ScreenType.FURNACE, ScreenType.BLAST_FURNACE, ScreenType.SMOKER);

		if(cookProgress<0) cookProgress=0;
		else if(cookProgress>1) cookProgress=1;
		gui.propertyDelegate.method_17391(2, (int) (1000*cookProgress));
	}
	public static void setFurnaceFuelProgress(InvGUI<?> gui, double fuelProgress){
		checkGUIType(gui, "Tried to set fuel data of gui "+gui+", but the gui is not a furnace type gui!",
				ScreenType.FURNACE, ScreenType.BLAST_FURNACE, ScreenType.SMOKER);

		if(fuelProgress<0) fuelProgress=0;
		else if(fuelProgress>1) fuelProgress=1;
		gui.propertyDelegate.method_17391(0, (int) (1000*fuelProgress));
	}
	public static void setBrewingFuel(InvGUI<?> gui, int fuelAmt){
		checkGUIType(gui, "Tried to set fuel of gui "+gui+", but the gui is not a brewing gui!",
				ScreenType.BREWING_STAND);

		gui.propertyDelegate.method_17391(1, fuelAmt);
	}
	public static void setBrewingTime(InvGUI<?> gui, int time){
		checkGUIType(gui, "Tried to set time of gui "+gui+", but the gui is not a brewing gui!",
				ScreenType.BREWING_STAND);

		gui.propertyDelegate.method_17391(0, time);
	}

	@Override
	public void onInitializeServer() {
		//if(MinecraftServer.class.getSimpleName().equals("MinecraftServer")) Testing.test();
		LOGGER.info("Server GUIs loaded!");
	}

	public static <T> ClickConsumer<T> nothingClick(){ return (_1, _2, _3, _4, _5, _6)->{}; }

	public static final InvGUIItem IMMOVABLE = new InvGUIItem() {
		private static final class_1799 item = class_1802.field_8157.method_7854().method_7977(class_2561.method_30163("§f"));
		private static final ClickConsumer<?> onClick = ServerGUIs.nothingClick();

		@Override
		public class_1799 getItem(class_3222 player, Object argument) { return item; }
		@Override
		public ClickConsumer<?> onClick() { return onClick; }
	};
	public static final InvGUIItem EMPTY = new InvGUIItem() {
		@Override
		public class_1799 getItem(class_3222 player, Object argument) {
			return class_1799.field_8037;
		}

		@Override
		public ClickConsumer<?> onClick() {
			return ServerGUIs.nothingClick();
		}
	};

	public static class_1799 getPlayerHead(int i1, int i2, int i3, int i4, String textureString){
		var val = new class_2487();
		val.method_10582("Value", textureString);
		var textures = new class_2499();
		textures.method_10531(0, val);
		var props = new class_2487();
		props.method_10566("textures", textures);

		var nbt = new class_2487();
		nbt.method_10566("Id",new class_2495(new int[]{i1, i2, i3, i4}));
		nbt.method_10566("Properties",props);

		var finalCompound = new class_2487();
		finalCompound.method_10566("SkullOwner",nbt);

		var head = new class_1799(class_2246.field_10432);
		head.method_7980(finalCompound);
		return head;
	}
	public static class_1799 getPlayerHead(String username){
		var finalCompound = new class_2487();
		finalCompound.method_10566("SkullOwner", class_2519.method_23256(username));

		var head = new class_1799(class_2246.field_10432);
		head.method_7980(finalCompound);
		return head;
	}
}
