package com.kyfexuwu.server_guis;

import ;
import com.kyfexuwu.server_guis.consumers.ClickConsumer;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_3222;

public interface InvGUIItem{
    class_1799 getItem(class_3222 player, Object argument);
    ClickConsumer<?> onClick();

    class InvGUIEntry{
        public final char key;
        public final Supplier<InvGUIItem> item;

        public InvGUIEntry(char key, InvGUIItem item){
            this.key=key;
            this.item=()->item;
        }
        public InvGUIEntry(char key, Supplier<InvGUIItem> item){
            this.key=key;
            this.item=item;
        }
    }
    static InvGUIItem[] decode(String map, InvGUIItem.InvGUIEntry... translations){
        var toReturn = new InvGUIItem[map.length()];
        for(int i=0;i<toReturn.length;i++){
            int finalI = i;
            var toSet=Arrays.stream(translations).filter(entry->entry.key==map.charAt(finalI))
                    .findFirst();
            if(toSet.isPresent())
                toReturn[i] = toSet.get().item.get();
            else
                toReturn[i] = ServerGUIs.EMPTY;
        }

        return toReturn;
    }
}
