package com.kyfexuwu.server_guis.mixin;

import com.kyfexuwu.server_guis.ServerGuiHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Optional;
import net.minecraft.class_1291;
import net.minecraft.class_2600;
import net.minecraft.class_2811;
import net.minecraft.class_2855;
import net.minecraft.class_2866;
import net.minecraft.class_3222;
import net.minecraft.class_3244;

@Mixin(class_3244.class)
public class ServerEventsMixin {
    @Shadow public class_3222 player;

    @Inject(method="onRenameItem",at=@At("HEAD"), cancellable = true)
    public void onRenameItem__serverguis(class_2855 packet, CallbackInfo ci) {
        class_2600.method_11073(packet, (class_3244)(Object)this,
                this.player.method_14220());
        if (this.player.field_7512 instanceof ServerGuiHandler handler) {
            handler.gui.onAnvilType(packet.method_12407());
            ci.cancel();
        }
    }

    @Inject(method="onUpdateBeacon",at=@At("HEAD"), cancellable = true)
    public void onUpdateBeacon__serverguis(class_2866 packet, CallbackInfo ci) {
        class_2600.method_11073(packet, (class_3244)(Object)this,
                this.player.method_14220());
        if (this.player.field_7512 instanceof ServerGuiHandler handler) {
            handler.gui.onBeaconChange(
                    Optional.ofNullable(class_1291.method_5569(packet.method_12436())),
                    Optional.ofNullable(class_1291.method_5569(packet.method_12435())));
            ci.cancel();
        }
    }

    @Inject(method="onButtonClick", at=@At("HEAD"), cancellable = true)
    //this is needed because server does a bunch of checks to see if the gui is valid
    public void onButtonClick__serverguis(class_2811 packet, CallbackInfo ci) {
        class_2600.method_11073(packet, (class_3244)(Object)this,
                this.player.method_14220());
        if (this.player.field_7512 instanceof ServerGuiHandler handler) {
            handler.gui.onButtonClick(packet.method_12186());
            ci.cancel();
        }
    }
}
