package com.kyfexuwu.server_guis;

import I;
import com.kyfexuwu.server_guis.consumers.ClickConsumer;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3222;

public class ServerGuiHandler extends class_1703 {

    public final InvGUI<?> gui;
    public final class_1263 inventory;
    public final ServerGUIs.ScreenType type;
    final class_3222 player;
    final Object argument;

    private static class CustomSlot extends class_1735{
        private final boolean canInteract;
        public CustomSlot(class_1263 inventory, int index, boolean canInteract) {
            super(inventory, index, 0,0);
            this.canInteract=canInteract;
        }

        @Override
        public boolean method_7674(class_1657 p){
            return this.canInteract;
        }
        @Override
        public boolean method_7680(class_1799 stack){ return this.canInteract; }
    }
    public ServerGuiHandler(int syncId, class_1661 playerInventory, ServerGUIs.ScreenType type, InvGUI<?> gui, Object argument) {
        super(type.type, syncId);
        this.type=type;

        this.consumers = new ClickConsumer[type.slotCount];

        this.argument = argument;

        this.inventory = new class_1277(type.slotCount +36);
        this.inventory.method_5435(playerInventory.field_7546);

        this.player = (class_3222) playerInventory.field_7546;
        for(int i = 0; i < type.slotCount; i++){
            if(gui.items.length>i){
                this.method_7621(new CustomSlot(this.inventory, i, gui.items[i] instanceof RemovableInvGUIItem));
                this.putInvGUIItem(i, gui.items[i]);
            }else{
                this.method_7621(new CustomSlot(this.inventory, i,false));
                this.putInvGUIItem(i, ServerGUIs.EMPTY);
            }
        }

        for(int y = 0; y < 3; y++) {
            for(int x = 0; x < 9; x++) {
                this.method_7621(new class_1735(playerInventory, x+y*9+9, 0, 0));
            }
        }
        for(int i = 0; i < 9; i++) {
            this.method_7621(new class_1735(playerInventory, i, 0, 0));
        }

        this.gui=gui;

        this.method_17360(this.gui.propertyDelegate);

        if(this.type == ServerGUIs.ScreenType.FURNACE ||
                this.type == ServerGUIs.ScreenType.BLAST_FURNACE ||
                this.type == ServerGUIs.ScreenType.SMOKER){
            this.gui.propertyDelegate.method_17391(3, 1000);
            this.gui.propertyDelegate.method_17391(1, 1000);
        }
    }

    private boolean isGuiSlot(int slotIndex){
        return slotIndex>=0&&slotIndex<this.type.slotCount;
    }

    @Override
    public class_1799 method_7601(class_1657 player, int slot) {
        if(!this.isGuiSlot(slot)){
            //quickmove from player to gui, slot is always greater than this.type.slotCount

            for(int i=0;i<this.type.slotCount;i++){
                var stack = this.field_7761.get(slot).method_7677();
                if(stack.method_7960()) break;
                if(!this.field_7761.get(i).method_7680(stack)) continue;

                var insertInto = this.inventory.method_5438(i);
                if(this.gui.items[i] instanceof RemovableInvGUIItem invGUIItem &&
                        (class_1799.method_31577(stack, insertInto)||insertInto.method_7960())){
                    var moveAmt = Math.min(insertInto.method_7914()-insertInto.method_7947(),stack.method_7947());
                    var newDisp = stack.method_7972();
                    newDisp.method_7939(moveAmt+invGUIItem.display.method_7947());
                    invGUIItem.display=newDisp;
                    stack.method_7934(moveAmt);
                }
            }

            this.refresh();
            return class_1799.field_8037;
        }
        return this.gui.onShiftClick(slot);
    }

    @Override
    public boolean method_7597(class_1657 player1) { return true; }

    @Override
    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        if(this.isGuiSlot(slotIndex)){
            if(this.consumers[slotIndex]!=null){
                this.consumers[slotIndex].consume(slotIndex, button, actionType, (class_3222) player,
                        this.gui, appeaseCompiler(this.argument));
            }
            return;
        }

        super.method_7593(slotIndex, button, actionType, player);
    }

    private boolean closeQuietly=false;
    @Override
    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if(!this.closeQuietly) {
            this.gui.onClose();
        }
    }

    @Override
    public boolean method_7604(class_1657 player, int id){
        return this.gui.onButtonClick(id);
    }
    private final ClickConsumer<?>[] consumers;
    public void putInvGUIItem(int slot, InvGUIItem item){
        this.method_7619(slot, 0, item.getItem(this.player, this.gui, this.argument));
        this.consumers[slot]=item.onClick();
    }

    public void refresh(){
        for(int i = 0; i < this.inventory.method_5439()-36; i++){
            var item1 = this.gui.items[i].getItem(this.player, this.gui, this.argument);
            var item2 = this.inventory.method_5438(i);

            if(!class_1799.method_7987(item1,item2) || (
                    item1.method_7985()?
                            !item1.method_7969().equals(item2.method_7969()):
                            !item2.method_7985())) {
                this.method_7619(i, 0, item1);
            }
        }
    }

    public void closeQuietly(){
        this.closeQuietly=true;
        this.player.method_7346();
    }

    static <T> T appeaseCompiler(Object toConvert){
        try {
            return (T) toConvert;
        }catch(ClassCastException e){
            return null;
        }
    }
}
