package com.kyfexuwu.server_guis;

import com.kyfexuwu.server_guis.ServerGUIs.ScreenType;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1291;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_3943;

public class PropertyHelpers {
    private static void checkGUIType(InvGUI<?> gui, String errorMessage, ServerGUIs.ScreenType... types){
        for(var type : types){
            if(gui.type==type) return;
        }
        throw new IllegalArgumentException(errorMessage);
    }
    private static void throwGuiDataTypeError(String name, Class<?> type){
        ServerGUIs.LOGGER.error("The \""+name+"\" data is invalid! Check if it exists " +
                "and is of type "+type.getSimpleName());
    }

    public static void setBeaconLevel(InvGUI<?> gui, int level){
        checkGUIType(gui, "Tried to set beacon level of gui "+gui+", but the gui is not a beacon gui!",
                ServerGUIs.ScreenType.BEACON);

        gui.propertyDelegate.method_17391(0,level);
    }
    public static void setBeaconEffects(InvGUI<?> gui, Optional<class_1291> effect1, Optional<class_1291> effect2){
        checkGUIType(gui, "Tried to set status effects of gui "+gui+", but the gui is not a beacon gui!",
                ServerGUIs.ScreenType.BEACON);

        effect1.ifPresent(statusEffect ->
                gui.propertyDelegate.method_17391(1, class_1291.method_5554(statusEffect)));
        effect2.ifPresent(statusEffect ->
                gui.propertyDelegate.method_17391(2, class_1291.method_5554(statusEffect)));
    }

    public static void setFurnaceCookProgress(InvGUI<?> gui, double cookProgress){
        checkGUIType(gui, "Tried to set cook data of gui "+gui+", but the gui is not a furnace type gui!",
                ServerGUIs.ScreenType.FURNACE, ServerGUIs.ScreenType.BLAST_FURNACE, ServerGUIs.ScreenType.SMOKER);

        if(cookProgress<0) cookProgress=0;
        else if(cookProgress>1) cookProgress=1;
        gui.propertyDelegate.method_17391(2, (int) (1000*cookProgress));
    }
    public static void setFurnaceFuelProgress(InvGUI<?> gui, double fuelProgress){
        checkGUIType(gui, "Tried to set fuel data of gui "+gui+", but the gui is not a furnace type gui!",
                ServerGUIs.ScreenType.FURNACE, ServerGUIs.ScreenType.BLAST_FURNACE, ServerGUIs.ScreenType.SMOKER);

        if(fuelProgress<0) fuelProgress=0;
        else if(fuelProgress>1) fuelProgress=1;
        gui.propertyDelegate.method_17391(0, (int) (1000*fuelProgress));
    }

    public static void setBrewingFuel(InvGUI<?> gui, int fuelAmt){
        checkGUIType(gui, "Tried to set fuel of gui "+gui+", but the gui is not a brewing gui!",
                ServerGUIs.ScreenType.BREWING_STAND);

        gui.propertyDelegate.method_17391(1, fuelAmt);
    }
    public static void setBrewingTime(InvGUI<?> gui, int time){
        checkGUIType(gui, "Tried to set time of gui "+gui+", but the gui is not a brewing gui!",
                ServerGUIs.ScreenType.BREWING_STAND);

        gui.propertyDelegate.method_17391(0, time);
    }

    public static void setBannerPattern(InvGUI<?> gui, int pattern){
        checkGUIType(gui, "Tried to set pattern of gui "+gui+", but the gui is not a loom gui!",
                ServerGUIs.ScreenType.LOOM);

        gui.propertyDelegate.method_17391(0, pattern);
    }

    public static boolean handleBookPageTurning(InvGUI<?> gui, int buttonIndex){
        checkGUIType(gui, "Tried to handle book pages of gui "+gui+", but the gui is not a lectern gui!",
                ServerGUIs.ScreenType.LECTERN);

        if(buttonIndex==1||buttonIndex==2){
            gui.propertyDelegate.method_17391(0, gui.propertyDelegate.method_17390(0)-3+buttonIndex*2);
            return true;
        }
        return false;
    }
    public static void setBookPage(InvGUI<?> gui, int pageIndex){
        checkGUIType(gui, "Tried to set page of gui "+gui+", but the gui is not a lectern gui!",
                ServerGUIs.ScreenType.LECTERN);

        gui.propertyDelegate.method_17391(0, pageIndex);
    }

    public static class EnchantmentData{
        public int id;
        public int level;
        public int xpAmt;

        private static final Random random = new Random();
        private static int calcRandomExperience(int slot){
            return Math.min(30, Math.max(1,
                    (random.nextInt(8) + random.nextInt(16) + 8)*(slot+1)/3)); //clamps between 1 and 30
        }

        public EnchantmentData(int id, int level, int xpAmt){
            this.id=id;
            this.level=level;
            this.xpAmt=xpAmt;
        }

        public static class EnchantmentDataBuilder{
            private int id=-1;
            private int level=1;
            private int xpAmt=-1;
            private EnchantmentDataBuilder(){}

            public EnchantmentDataBuilder setEnchantmentId(int id){
                if(id<0) return this;

                this.id=id;
                return this;
            }
            public EnchantmentDataBuilder setEnchantment(class_1887 enchantment){
                this.id= class_2378.field_11160.method_10206(enchantment);
                return this;
            }

            public EnchantmentDataBuilder setLevel(int level){
                if(level<1) return this;

                this.level=level;
                return this;
            }

            public EnchantmentDataBuilder setXPAmt(int amt){
                if(amt<0) return this;

                this.xpAmt=amt;
                return this;
            }
            public EnchantmentDataBuilder setRandomXPAmt(int slot){
                this.xpAmt=calcRandomExperience(slot);
                return this;
            }

            public EnchantmentData build(){
                if(this.xpAmt==-1) this.xpAmt = calcRandomExperience(0);
                return new EnchantmentData(this.id, this.level, this.xpAmt);
            }
        }
        public static EnchantmentDataBuilder builder(){
            return new EnchantmentDataBuilder();
        }
    }
    public static void setEnchatingTableEnchantments(InvGUI<?> gui,
                                                     Optional<EnchantmentData> ench1, Optional<EnchantmentData> ench2, Optional<EnchantmentData> ench3){
        checkGUIType(gui, "Tried to set enchanting data of gui "+gui+", but the gui is not an enchanting table gui!",
                ServerGUIs.ScreenType.ENCHANTMENT);

        ench1.ifPresent(data->{
            gui.propertyDelegate.method_17391(0, data.xpAmt);
            gui.propertyDelegate.method_17391(4, data.id);
            gui.propertyDelegate.method_17391(7, data.level);
        });
        ench2.ifPresent(data->{
            gui.propertyDelegate.method_17391(1, data.xpAmt);
            gui.propertyDelegate.method_17391(5, data.id);
            gui.propertyDelegate.method_17391(8, data.level);
        });
        ench3.ifPresent(data->{
            gui.propertyDelegate.method_17391(2, data.xpAmt);
            gui.propertyDelegate.method_17391(6, data.id);
            gui.propertyDelegate.method_17391(9, data.level);
        });
    }

    public static void setTrades(InvGUI<?> gui,
                                 boolean displaysLevel, int merchantLevel, int progressToNextLevel, boolean canRefresh,
                                 class_1916 trades){
        checkGUIType(gui, "Tried to set trades of gui "+gui+", but the gui is not a merchant gui!",
                ServerGUIs.ScreenType.MERCHANT);

        var toSend = new class_3943(gui.getHandler().field_7763,
                trades, merchantLevel, progressToNextLevel, displaysLevel, canRefresh);

        gui.setData("builtin.trades", trades);
        gui.getHandler().player.field_13987.method_14364(toSend);
    }
    public static boolean handleTradeButtons(InvGUI<?> gui, int buttonIndex){
        checkGUIType(gui, "Tried to handle trade buttons of gui "+gui+", but the gui is not a merchant gui!",
                ServerGUIs.ScreenType.MERCHANT);

        if(!(gui.items[0] instanceof RemovableInvGUIItem &&
                gui.items[1] instanceof RemovableInvGUIItem &&
                gui.items[2] instanceof RemovableInvGUIItem))
            throw new IllegalStateException("All of this gui's slots must be RemovableInvGUIItems!");

        class_1916 trades;
        try{
            trades = gui.getDataOfType("builtin.trades", class_1916.class);
        }catch(ClassCastException e){
            throwGuiDataTypeError("builtin.trades", class_1916.class);
            return true;
        }

        if (buttonIndex >= 0 && buttonIndex < trades.size()) {
            var handler = gui.getHandler();

            for(int counter=0;counter<2;counter++){
                class_1799 toInsert = gui.items[counter].getItem(
                        gui.getHandler().player, gui, gui.getHandler().argument);
                int[] addVals = new int[36];
                int insertAmt=toInsert.method_7947();
                class_1799 currStack;

                for(int i=0;i<36;i++){
                    currStack=handler.inventory.method_5438(handler.type.slotCount+i);
                    if(class_1799.method_31577(currStack, toInsert)){
                        addVals[i]=Math.min(currStack.method_7914()-currStack.method_7947(),insertAmt);
                        insertAmt-=addVals[i];

                        if(insertAmt<=0) break;
                    }
                }
                if(insertAmt>0) return true;
                for(int i=0;i<36;i++)
                    handler.inventory.method_5438(handler.type.slotCount+i).method_7933(addVals[i]);
            }

            class_1799 toTake1 = trades.get(buttonIndex).method_19272();
            int toTakeC1 = handler.player.method_31548().method_29280(stack->stack.method_31574(toTake1.method_7909()),
                    toTake1.method_7947(), handler.player.method_31548());
            var toDisplay1 = toTake1.method_7972();
            toDisplay1.method_7939(toTakeC1);
            ((RemovableInvGUIItem) handler.gui.items[0]).display = toDisplay1;

            class_1799 toTake2 = trades.get(buttonIndex).method_8247();
            int toTakeC2 = handler.player.method_31548().method_29280(stack->stack.method_31574(toTake2.method_7909()),
                    toTake2.method_7947(), handler.player.method_31548());
            var toDisplay2 = toTake2.method_7972();
            toDisplay2.method_7939(toTakeC2);
            ((RemovableInvGUIItem) handler.gui.items[1]).display = toTake2;

            gui.setData("builtin.merchantSellingItem", class_1799.field_8037);

        }

        gui.setData("builtin.merchantTradeIndex", buttonIndex);
        return true;
    }
    public static void handleTradeSlots(InvGUI<?> gui){
        checkGUIType(gui, "Tried to handle trade slots of gui "+gui+", but the gui is not a merchant gui!",
                ServerGUIs.ScreenType.MERCHANT);

        if(!(gui.items[0] instanceof RemovableInvGUIItem &&
                gui.items[1] instanceof RemovableInvGUIItem &&
                gui.items[2] instanceof RemovableInvGUIItem))
            throw new IllegalStateException("All of this gui's slots must be RemovableInvGUIItems!");

        class_1799 sellingItem=class_1799.field_8037;
        try {
            sellingItem=gui.getDataOfType("builtin.merchantSellingItem", class_1799.class);
            if(sellingItem==null) sellingItem=class_1799.field_8037;
        }catch(ClassCastException e){
            throwGuiDataTypeError("builtin.merchantSellingItem", class_1799.class);
        }
        if(!sellingItem.method_7960()&&!class_1799.method_7973(sellingItem,((RemovableInvGUIItem) gui.items[2]).display)){
            gui.getHandler().player.method_7270(((RemovableInvGUIItem) gui.items[2]).display);
            try {
                var trade = gui.getDataOfType("builtin.merchantTrade", class_1914.class);
                if(trade==null) return;

                if(((RemovableInvGUIItem) gui.items[0]).display.method_31574(trade.method_19272().method_7909())) {
                    ((RemovableInvGUIItem) gui.items[0]).display.method_7934(trade.method_19272().method_7947());
                    ((RemovableInvGUIItem) gui.items[1]).display.method_7934(trade.method_8247().method_7947());
                }else{
                    ((RemovableInvGUIItem) gui.items[1]).display.method_7934(trade.method_19272().method_7947());
                    ((RemovableInvGUIItem) gui.items[0]).display.method_7934(trade.method_8247().method_7947());
                }

            }catch(ClassCastException e){
                throwGuiDataTypeError("builtin.merchantTrade", class_1914.class);
                return;
            }

            gui.setData("builtin.merchantTrade", null);
            gui.setData("builtin.merchantSellingItem", class_1799.field_8037);
        }

        class_1799 primarySell = ((RemovableInvGUIItem) gui.items[0]).display;
        class_1799 secondarySell = ((RemovableInvGUIItem) gui.items[1]).display;
        if(primarySell.method_7960()){
            primarySell = secondarySell;
            secondarySell = class_1802.field_8162.method_7854();
        }

        if (primarySell.method_7960()) {
            ((RemovableInvGUIItem) gui.items[2]).display = class_1799.field_8037;
            gui.setData("builtin.merchantTrade", null);
        } else {
            class_1916 tradeOfferList;
            try{
                tradeOfferList=gui.getDataOfType("builtin.trades", class_1916.class);
            }catch(ClassCastException e){
                throwGuiDataTypeError("builtin.trades", class_1916.class);
                return;
            }

            int index=-1;
            try{
                index=gui.getDataOfType("builtin.merchantTradeIndex", Integer.class);
            }catch(ClassCastException | NullPointerException ignored){}

            class_1914 tradeOffer = tradeOfferList.method_8267(primarySell, secondarySell, index);
            if (tradeOffer == null || tradeOffer.method_8255()) {
                tradeOffer = tradeOfferList.method_8267(secondarySell, primarySell, index);
            }
            if (tradeOffer != null && !tradeOffer.method_8255()) {
                ((RemovableInvGUIItem) gui.items[2]).display = tradeOffer.method_18019();
                gui.setData("builtin.merchantTrade", tradeOffer);
            } else {
                ((RemovableInvGUIItem) gui.items[2]).display = class_1799.field_8037;
                gui.setData("builtin.merchantTrade", null);
            }

            gui.setData("builtin.merchantSellingItem", ((RemovableInvGUIItem) gui.items[2]).display.method_7972());
            gui.getHandler().refresh();
        }
    }
    public static class_1916 createTrades(class_1914... trades){
        var nbt = new class_2487();

        var tradesNBT = new class_2499();
        nbt.method_10566("Recipes", tradesNBT);

        for (class_1914 trade : trades) {
            tradesNBT.add(trade.method_8251());
        }

        return new class_1916(nbt);
    }
}
