package com.kyfexuwu.server_guis;

import com.kyfexuwu.server_guis.consumers.*;
import net.minecraft.class_1291;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3919;
import net.minecraft.screen.*;
import java.util.HashMap;
import java.util.Optional;

public class InvGUI<T> {
    @FunctionalInterface
    public interface Builder<T>{
        InvGUI<T> build(class_3222 player, Template<T> template, T argument);
    }
    public static class Template<T> {
        public final ServerGUIs.ScreenType type;
        public final class_2561 title;
        public final InvGUIItem[] items;
        private Builder<T> builder = (player, template, arg) -> new InvGUI<>(template.type, template.title, template.items);
        private CloseConsumer<T> onCloseConsumer = (player, thisInv, argument) -> { };
        private ButtonClickConsumer<T> onButtonClickConsumer = (player, thisInv, argument, buttonIndex) -> true;
        private ShiftClickConsumer<T> onShiftClickConsumer = (player, thisInv, argument, slotNum) -> class_1799.field_8037;
        private SlotUpdateConsumer<T> onSlotUpdateConsumer = (player, thisInv, argument, slotNum, stack) -> {};
        private PropertyUpdateConsumer<T> onPropertyUpdateConsumer = (player, thisInv, argument, property, value) -> {};
        private AnvilTypeConsumer<T> onAnvilTypeConsumer = (player, thisInv, argument, newText) -> { };
        private BeaconInteractionConsumer<T> onBeaconChangeConsumer = (player, thisInv, argument, effect1, effect2) -> { };
        public Template(ServerGUIs.ScreenType type, class_2561 title, InvGUIItem[] items) {
            this.type = type;
            this.title = title;
            this.items = items;
        }
        public Template<T> toBuild(Builder<T> builder){
            this.builder=builder;
            return this;
        }
        public Template<T> onClose(CloseConsumer<T> onClose){
            this.onCloseConsumer=onClose;
            return this;
        }
        public Template<T> onButtonClick(ButtonClickConsumer<T> onButtonClick){
            this.onButtonClickConsumer=onButtonClick;
            return this;
        }
        public Template<T> onShiftClick(ShiftClickConsumer<T> onShiftClick){
            this.onShiftClickConsumer=onShiftClick;
            return this;
        }
        public Template<T> onSlotUpdate(SlotUpdateConsumer<T> onSlotUpdate){
            this.onSlotUpdateConsumer=onSlotUpdate;
            return this;
        }
        public Template<T> onPropertyUpdate(PropertyUpdateConsumer<T> onPropertyUpdate){
            this.onPropertyUpdateConsumer=onPropertyUpdate;
            return this;
        }
        public Template<T> onAnvilType(AnvilTypeConsumer<T> onAnvilType){
            this.onAnvilTypeConsumer=onAnvilType;
            return this;
        }
        public Template<T> onBeaconChange(BeaconInteractionConsumer<T> onBeaconChange){
            this.onBeaconChangeConsumer=onBeaconChange;
            return this;
        }
        public InvGUI<T> build(class_3222 player, T arg){
            var toReturn = this.builder.build(player,this, arg);
            toReturn.onClose=this.onCloseConsumer;
            toReturn.onButtonClick=this.onButtonClickConsumer;
            toReturn.onShiftClick=this.onShiftClickConsumer;
            toReturn.onSlotUpdate=this.onSlotUpdateConsumer;
            toReturn.onPropertyUpdate=this.onPropertyUpdateConsumer;
            toReturn.onAnvilType=this.onAnvilTypeConsumer;
            toReturn.onBeaconChange=this.onBeaconChangeConsumer;
            return toReturn;
        }
        public void buildAndOpen(class_3222 player, T arg){
            this.build(player, arg).open(player, arg);
        }
    }
    private ServerGuiHandler handler;
    public ServerGuiHandler getHandler(){ return this.handler; }
    public final ServerGUIs.ScreenType type;
    public final class_2561 title;
    public final InvGUIItem[] items;
    public final class_3913 propertyDelegate;
    private CloseConsumer<T> onClose;
    private ButtonClickConsumer<T> onButtonClick;
    private ShiftClickConsumer<T> onShiftClick;
    private SlotUpdateConsumer<T> onSlotUpdate;
    private PropertyUpdateConsumer<T> onPropertyUpdate;
    private AnvilTypeConsumer<T> onAnvilType;
    private BeaconInteractionConsumer<T> onBeaconChange;
    public void onClose(){
        this.onClose.consume(this.handler.player,
                this, ServerGuiHandler.appeaseCompiler(this.handler.argument));

        //give back removable items
        for(InvGUIItem item : this.items){
            if(item instanceof RemovableInvGUIItem){
                this.handler.player.method_7270(((RemovableInvGUIItem) item).display);
            }
        }
    }
    public boolean onButtonClick(int buttonIndex){
        return this.onButtonClick.consume(this.handler.player,
                this,ServerGuiHandler.appeaseCompiler(this.handler.argument),
                buttonIndex);
    }
    public class_1799 onShiftClick(int slotNum){
        return this.onShiftClick.consume(this.handler.player,
                this,ServerGuiHandler.appeaseCompiler(this.handler.argument),
                slotNum);
    }
    public void onSlotUpdate(int slotNum, class_1799 stack){
        this.onSlotUpdate.consume(this.handler.player,
                this, ServerGuiHandler.appeaseCompiler(this.handler.argument),
                slotNum, stack);
    }
    public void onPropertyUpdate(int property, int value){
        this.onPropertyUpdate.consume(this.handler.player,
                this, ServerGuiHandler.appeaseCompiler(this.handler.argument),
                property, value);
    }
    public void onAnvilType(String newText){
        this.setData("builtin.anvilText", newText);
        this.onAnvilType.consume(this.handler.player,
                this, ServerGuiHandler.appeaseCompiler(this.handler.argument),
                newText);
    }
    public void onBeaconChange(Optional<class_1291> effect1, Optional<class_1291> effect2){
        this.onBeaconChange.consume(this.handler.player,
                this, ServerGuiHandler.appeaseCompiler(this.handler.argument),
                effect1, effect2);
    }

    public InvGUI(ServerGUIs.ScreenType type, class_2561 title, InvGUIItem[] items) {
        this.type = type;
        this.title = title;
        this.items = items;

        this.propertyDelegate = new class_3919(type.propCount);
    }

    public void open(class_3222 player, T argument){
        var thisObj = this;

        player.method_17355(new class_3908() {
            @Override
            public class_2561 method_5476() {
                return thisObj.title;
            }

            @Override
            public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
                thisObj.handler = new ServerGuiHandler(syncId, playerInventory, thisObj.type, thisObj, argument);
                thisObj.handler.method_7596(new class_1712() {
                    @Override
                    public void method_7635(class_1703 handler, int slotNum, class_1799 stack) {
                        thisObj.onSlotUpdate(slotNum, stack);
                    }

                    @Override
                    public void method_7633(class_1703 handler, int property, int value) {
                        thisObj.onPropertyUpdate(property, value);//todo: make the properties human readable?
                    }
                });

                return thisObj.handler;
            }
        });
    }

    private final HashMap<String, Object> data = new HashMap<>();
    public Object getData(String name){
        return this.data.getOrDefault(name, null);
    }
    public <T> T getDataOfType(String name, Class<T> clazz){
        return (T) this.data.getOrDefault(name, null);
    }
    public void setData(String name, Object data){
        this.data.put(name, data);
    }
}
